package it.eng.eremita.jpa.entity;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Table;

import io.leangen.graphql.annotations.GraphQLQuery;

@Entity
@Table(name="EREMITA_SPECIE_PROGETTO")
public class SpecieProgettoEremita {
	
	long id;
	Specie specie;
	String icona;
	String acquatica;
	
	@Id
	@Column(name="ID")
	@GraphQLQuery(name="id")
	public long getId() {
		return id;
	}
	public void setId(long id) {
		this.id = id;
	}
	
	@ManyToOne
	@JoinColumn(name="SPECIE")
	@GraphQLQuery(name="specie")
	public Specie getSpecie() {
		return specie;
	}
	public void setSpecie(Specie specie) {
		this.specie = specie;
	}
	
	@Column(name="ICONA")
	@GraphQLQuery(name="icona")
	public String getIcona() {
		return icona;
	}
	public void setIcona(String icona) {
		this.icona = icona;
	}
	
	@Column(name="ACQUATICA")
	@GraphQLQuery(name="acquatica")
	public String getAcquatica() {
		return acquatica;
	}
	public void setAcquatica(String acquatica) {
		this.acquatica = acquatica;
	}
	
	
	
	
	

}
